



<html>
<head>
  <title>javabog.dk -  - Dokumentation</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel1.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel3.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_VP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">2 <a name='afsn2'></a>Dokumentation</H1>
<DIV ID="Indholdsfortegnelse7">
  <P STYLE="margin-top: 0.3cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.1
  Javadoc  46</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.1.1
  API-dokumentation  46</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.1.2
  At dokumentere med javadoc  47</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.1.3
  Simpelt eksempel  47</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.1.4
  St&oslash;rre eksempel: Vector-klassen  48</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.1.5
  Oversigter  49</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.2
  K&oslash;rsel af javadoc  50</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.2.1
  Simpel brug  50</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.2.2
  Henvise til den eksisterende javadokumentation  50</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.3
  Appendiks  51</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.3.1
  Parametre til javadoc  51</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.3.2
  Koder tilg&aelig;ngelige i javadoc  52</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.3.3
  Pakkekommentarer  52</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.4
  Videre l&aelig;sning  53</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.5
  Opgaver  53</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.6
  L&oslash;sninger  54</B></FONT></FONT></P>
</DIV>













<P CLASS="kapiteloversigt-western">En overfladisk forst&aring;else af
dette kapitel er en fordel i resten af bogen.</P>

<P CLASS="kapiteloversigt-western">Tak til Jonas <SPAN LANG="da-DK">Kongslund</SPAN>
og Sk&aring;ne Sj&aelig;lland Linux-brugergruppe, der har doneret
udgangspunktet til kapitlet, fra <A CLASS="western" HREF="http://www.linuxbog.dk/java/bog/">http://<SPAN LANG="da-DK">www.linuxbog.dk</SPAN>/java/bog/</A>.</P>
<P CLASS="western" STYLE="">Dokumentation er
et vigtigt aspekt af ethvert <SPAN LANG="da-DK">programudviklingsprojekt.</SPAN>
Dokumentationen kan have mange former og modtagere. Det kan f.eks.
v&aelig;re:</P>
<UL>
  <LI><P CLASS="western">Henvendt til slutbrugeren og vejlede i,
  hvordan programmet bruges (brugervejledning)</P>
</UL>
<UL>
  <LI><P CLASS="western">Henvendt til
  driftsafdelingen/systemadministratoren og vejlede i:</P>
</UL>
<UL>
  <LI><P CLASS="western">Udseende og fortolkning af logfiler</P>
  <LI><P CLASS="western">Hvordan programmet skal bringes til at
  fungere igen, hvis det stopper</P>
  <LI><P CLASS="western">Hvilke foruds&aelig;tninger der skal g&aelig;lde
  (f.eks. hvilke andre programmer der skal v&aelig;re installeret og i
  hvilke versioner), for at programmet fungerer</P>
  <LI><P CLASS="western">Hvordan programmet installeres og
  konfigureres</P>
</UL>
<UL>
  <LI><P CLASS="western">Henvendt til en anden programm&oslash;r som
  dokumentation af et f&aelig;rdigt program, som programm&oslash;ren
  skal vedligeholde:</P>
</UL>
<UL>
  <LI><P CLASS="western">Testtilf&aelig;lde (inddata og forventede
  uddata)</P>
  <LI><P CLASS="western">Analyse- og <SPAN LANG="da-DK">designdokumenter</SPAN>,
  herunder klassediagrammer</P>
  <LI><P CLASS="western">Beskrivelse af klasser, metoder og variabler
  (javadoc)</P>
</UL>
<UL>
  <LI><P CLASS="western">Henvendt til en anden programm&oslash;r som
  dokumentation af et API-programbibliotek som skal bruges fra et
  program:</P>
</UL>
<UL>
  <LI><P CLASS="western">Klassediagrammer</P>
  <LI><P CLASS="western">Beskrivelse af klasser, metoder og variabler
  (javadoc)</P>
</UL>
<P CLASS="western">Dette kapitel beskriver hvordan, man kan udarbejde
dokumentation med javadoc. 
</P>
<H2 CLASS="western">2.1 <a name='afsn2.1'></a>Javadoc</SPAN></H2>
<P CLASS="western">Javadoc er en beskrivelse af alle pakker, klasser,
interfaces, metoder og variabler, samt eventuelt vejledning i,
hvordan de b&oslash;r bruges. Den kan genereres ud fra kommentarer i
kildeteksten ved hj&aelig;lp af et udviklingsv&aelig;rkt&oslash;j
eller ved at k&oslash;re javadoc fra kommandolinjen (DOS-prompten).</P>
<H3 CLASS="western">2.1.1 <a name='afsn2.1.1'></a>API-dokumentation</H3>
<P CLASS="western">Et API (Application Programming Interface) er et
s&aelig;t klasser, som man kan bruge i sit program, og som letter
programm&oslash;rens arbejde. F.eks. giver JDBC-klasserne let adgang
til forskellige databaser p&aring; en ensartet m&aring;de.</P>
<P CLASS="western">Dokumentationen af et API kan opfattes som en
kontrakt mellem den programm&oslash;r, der har implementeret
(skrevet) <SPAN LANG="da-DK">API'et</SPAN> (leverand&oslash;ren), og
den programm&oslash;r, der vil bruge API'et (klienten).</P>
<P CLASS="western">Hvis leverand&oslash;ren f.eks. lover at metoden
double <SPAN LANG="da-DK">sqr</SPAN>(int tal) returnerer kvadratroden
af tallet, n&aring;r det ikke er negativt, s&aring; ved klienten, at
uanset hvordan metoden er implementeret, s&aring; vil den altid
returnere kvadratroden med s&aring; stor pr&aelig;cision, som
returtypen tillader. 
</P>
<P CLASS="western">Hvis returv&aelig;rdien viser sig at v&aelig;re
forkert i nogle tilf&aelig;lde, s&aring; har leverand&oslash;ren
brudt kontrakten, og metoden er implementeret forkert. 
</P>
<P CLASS="western">Hvis klienten kalder metoden med et negativt tal,
er der ogs&aring; tale om kontraktbrud. Kontraktbrud kan enten
resultere i en undtagelse, eller at resultatet ikke er <SPAN LANG="da-DK">veldefineret.</SPAN></P>
<H3 CLASS="western" STYLE="">2.1.2 <a name='afsn2.1.2'></a>At
dokumentere med javadoc</H3>
<P CLASS="western">Kommentarer i kildeteksten, der starter med <CODE CLASS="western">/**</CODE>
og slutter med <CODE CLASS="western">*/</CODE>, opfattes som
specielle javadoc-kommentarer. B&aring;de inte<SPAN STYLE="font-weight: medium">rfaces,
klasser, variabler, konstrukt&oslash;rer og metoder kan dokumenteres
ved at lave en javadoc-kommentar umiddelbart f&oslash;r det, der skal
dokumenteres.</SPAN></P>
<H3 CLASS="western">2.1.3 <a name='afsn2.1.3'></a>Simpelt eksempel</H3>
<P CLASS="western"><IMG SRC="bog3_html_257bf205.png" NAME="Grafik11" ALIGN=RIGHT HSPACE=2 BORDER=0>Her
er en klasse med en metode. Begge er kommenteret med
javadoc-kommentarer:</P>
<PRE CLASS="kode-western"><I><B>/**</B></I>
<I><B> * Eksempel p&aring; en kommenteret klasse.</B></I>
<I><B> */</B></I>
public class EnKommenteretKlasse
{
<I><B>  /**</B></I>
<I><B>   * Et eksempel p&aring; en metode. Metoden tjener</B></I>
<I><B>   * til at vise hvordan javadoc virker.</B></I>
<I><B>   * </B></I>
<I><B>   * @param enStreng strengen</B></I>
<I><B>   * @param etTal tallet</B></I>
<I><B>   * </B></I>
<I><B>   * @return strengen og tallet sat sammen</B></I>
<I><B>   */</B></I>
  public String enMetode(String enStreng, 
                         int etTal)
  {
    return enStreng+etTal;
  }
}</PRE><P CLASS="western">
Bem&aelig;rk, hvordan kommentaren, der beskriver klassen, st&aring;r
umiddelbart f&oslash;r erkl&aelig;ringen af klassen:</P>
<PRE CLASS="ikke-javakode-western"><I>/**</I>
<I> * Eksempel p&aring; en kommenteret klasse.</I>
<I> */</I>
public class EnKommenteretKlasse
{
...</PRE><P CLASS="western">
Ligeledes st&aring;r kommentaren, der beskriver metoden, umiddelbart
f&oslash;r erkl&aelig;ringen af metoden:</P>
<PRE CLASS="kode-western"><I>  /**</I>
<I>   * Et eksempel p&aring; en metode. Metoden tjener</I>
<I>   * til at vise hvordan javadoc virker.</I>
<I>   * </I>
<I>   * @param enStreng strengen</I>
<I>   * @param etTal tallet</I>
<I>   * </I>
<I>   * @return strengen og tallet sat sammen</I>
<I>   */</I>
  public String enMetode(String enStreng, 
                         int etTal)
  { ...</PRE><P CLASS="western">
Her er de specielle javadoc-koder @param og <SPAN LANG="da-DK">@return</SPAN>
anvendt i javadoc-kommentaren (En liste over javadoc-koder kan findes
i <a href='kapitel2.jsp#afsn2.3.2'>afsnit 2.3.2</a>).</P>
<P CLASS="western">Nu kan vi generere en HTML-fil (med filnavnet
<SPAN LANG="da-DK">EnKommenteretKlasse.html</SPAN>) ved at udf&oslash;re
kommandoen:</P>
<PRE CLASS="western">  javadoc <SPAN LANG="da-DK">EnKommenteretKlasse.java</SPAN></PRE><P CLASS="western">
Resultatet er den velkendte dokumentation for klasser (vist til
h&oslash;jre).</P>
<H3 CLASS="western" STYLE="">2.1.4 <a name='afsn2.1.4'></a>St&oslash;rre
eksempel: Vector-klassen</H3>
<P CLASS="western">Da Vector-klassen er velkendt for de fleste, er
den valgt til at illustrere sammenh&aelig;ngen mellem
javadoc-kommentarerne i kildetekst og den genererede
HTML-dokumentation:</P>
<PRE CLASS="ikke-javakode-western"><FONT SIZE=1 STYLE="font-size: 8pt">package java.util;</FONT>

<FONT SIZE=1 STYLE="font-size: 8pt"><I><B>/**</B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * The &lt;code&gt;Vector&lt;/code&gt; class implements a growable array of </B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * objects. Like an array, it contains components that can be </B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * accessed using an integer index. However, the size of a </B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * &lt;code&gt;Vector&lt;/code&gt; can grow or shrink as needed to accommodate </B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * adding and removing items after the &lt;code&gt;Vector&lt;/code&gt; has been created.</B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * &lt;p&gt;</B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * Each vector tries to optimize storage management by maintaining a </B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * &lt;code&gt;capacity&lt;/code&gt; and a &lt;code&gt;capacityIncrement&lt;/code&gt;. The </B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * &lt;code&gt;capacity&lt;/code&gt; is always at least as large as the vector </B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * size; it is usually larger because as components are added to the </B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * vector, the vector's storage increases in chunks the size of </B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * &lt;code&gt;capacityIncrement&lt;/code&gt;. An application can increase the </B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * capacity of a vector before inserting a large number of </B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * components; this reduces the amount of incremental reallocation. </B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> *</B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> * @since   JDK1.0</B></I></FONT>
<FONT SIZE=1 STYLE="font-size: 8pt"><I><B> */</B></I></FONT>
public class Vector implements Cloneable, java.io.Serializable
{
  ... (nogle metoder og variabler)</PRE><P CLASS="western">
Ud fra denne del af kildeteksten genererer javadoc HTML-koden med den
overordnede beskrivelse af klassen:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog3_html_m2ca6ba8a.png" NAME="Grafik29" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western">Bem&aelig;rk, hvordan der bruges HTML-koder i
kildeteksten til at fremh&aelig;ve blandt andet klassenavne for at
&oslash;ge l&aelig;sevenligheden af den genererede dokumentation.</P>
<P CLASS="western">Forts&aelig;tter vi i kildeteksten til Vector 
(der findes samlet i <a href='kapitel1.jsp#afsn1.6.8'>afsnit 1.6.8</a>), kan vi se, hvordan javadoc
genererer HTML-kode (vist til h&oslash;jre) ud fra beskrivelsen af
metoderne og specielle javadoc-koder (beskrevet i <a href='kapitel2.jsp#afsn2.3.2'>afsnit 2.3.2</a>) som
@param, @return, @exception, @since og @see:</P>
<PRE CLASS="kode-western">  ...

<I>  /**</I>
<I>  <IMG SRC="bog3_html_m19398949.png" NAME="Grafik13" ALIGN=RIGHT BORDER=0> * Returns the component at the specified index.</I>
<I>   *</I>
<I>   * <B>@param  </B> index   an index into this vector.</I>
<I>   * <B>@return</B> the component at the specified index.</I>
<I>   * <B>@exception</B> ArrayIndexOutOfBoundsException if</I>
<I>   *             an invalid index was given.</I>
<I>   * <B>@since  </B>  JDK1.0</I>
<I>   */</I>
  public final Object elementAt(int index) {
    if (index &gt;= elementCount) {
      throw new ArrayIndexOutOfBoundsException(index + &quot; &gt;= &quot; + elementCount);
    }
    try {
      return elementData[index];
    } catch (ArrayIndexOutOfBoundsException e) {
      throw new ArrayIndexOutOfBoundsException(index + &quot; &lt; 0&quot;);
    }
  }

<I>  /**</I>
<I>   * Sets the component at the specified &lt;code&gt;index&lt;/code&gt; of this </I>
<I>   * vector to be the specified object. The previous component at that </I>
<I>   * position is discarded. </I>
<I>   * &lt;p&gt;</I>
<I>   * The index must be a value greater than or equal to &lt;code&gt;0&lt;/code&gt; </I>
<I>   * and less than the current size of the vector. </I>
<I>   *</I>
<I>   * <B>@param</B>   obj what the component is to be set to.</I>
<I>   * <B>@param  </B> index the specified index.</I>
<I>   * <B>@exception</B> ArrayIndexOutOfBoundsException if the index was invalid.</I>
<I>   * <B>@see  </B>  java.util.Vector#size()</I>
<I>   * <B>@since  </B>  JDK1.0</I>
<I>   */</I>
  public final void setElementAt(Object obj, int index) {
    if (index &gt;= elementCount) {
      throw new ArrayIndexOutOfBoundsException(index + &quot; &gt;= &quot; + 
                 elementCount);
    }
    elementData[index] = obj;
  }

  ...</PRE><H3 CLASS="western">
2.1.5 <a name='afsn2.1.5'></a>Oversigter</H3>
<P CLASS="western">Mellem den overordnede klassebeskrivelse og denne
(detaljerede) beskrivelse af metoderne findes en oversigt over
variabler, konstrukt&oslash;rer og metoder.</P>
<P CLASS="western">I oversigter st&aring;r generelt <I>kun teksten
indtil det f&oslash;rste punktum i javadoc-kommentarerne</I>. F.eks.
st&aring;r der i oversigten over metoder ('method summary') for
setElementAt() f&oslash;lgende:</P>
<P CLASS="western"><IMG SRC="bog3_html_m27a44add.png" NAME="Grafik30" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western">Resten af javadoc-kommentaren (efter punktummet)
er alts&aring; udeladt i oversigten (sammenlign med kommentaren til
setElementAt() ovenfor).</P>
<P CLASS="western">Det er derfor smart at lade den f&oslash;rste
s&aelig;tning i hver kommentar v&aelig;re beskrivende nok til, at man
hurtigt f&aring;r en id&eacute; om, hvad eksempelvis en metode g&oslash;r.</P>
<H2 CLASS="western">2.2 <a name='afsn2.2'></a>K&oslash;rsel af javadoc</SPAN></H2>
<P CLASS="western">Javadoc kan k&oslash;res fra kommandolinjen, men
er ogs&aring; indbygget i de fleste java-udviklingsmilj&oslash;er
(kunne f.eks. v&aelig;re under &quot;Tools&quot; / &quot;Generate
Javadoc&quot;).</P>
<P CLASS="western">I det f&oslash;lgende vil vi koncentrere os om
k&oslash;rsel fra kommandolinjen. Det foruds&aelig;ttes, at l&aelig;seren
er nogenlunde bekendt med kommandolinjen (f.eks. ved, hvordan man
skifter katalog).</P>
<P CLASS="western">F&aring;r du fejlen &quot;javadoc: Forkert
kommando eller filnavn&quot;, n&aring;r du skriver 'javadoc' p&aring;
kommandolinjen, er det, fordi java-udviklingskittet (<SPAN LANG="da-DK">JDK'en</SPAN>)
ikke er med i stien. Du kan da:</P>
<UL>
  <LI><P CLASS="western">Enten skrive den fulde sti, f.eks.:
  <BR><CODE CLASS="western">/<SPAN LANG="da-DK">usr</SPAN>/local/jdk1.4/bin/javadoc</CODE>
  (UNIX/Linux) eller <BR><CODE CLASS="western">\jdk1.4\bin\javadoc</CODE>
  (DOS/Windows) 
  </P>
  <LI><P CLASS="western">Eller &aelig;ndre stien (PATH-variablen),
  f.eks.:<BR><CODE CLASS="western">export
  PATH=/usr/local/jdk1.4/bin/:$PATH</CODE> (UNIX/Linux) eller <BR><CODE CLASS="western">set
  PATH=\jdk1.4\bin\;%PATH</CODE> (DOS/Windows) 
  </P>
</UL>
<H3 CLASS="western">2.2.1 <a name='afsn2.2.1'></a>Simpel brug</H3>
<P CLASS="western">Det simpleste er at skifte katalog til der, hvor
.java-filerne er og skrive:</P>
<PRE CLASS="western">  javadoc *.java</PRE><P CLASS="western">
Herefter vil HTML-filerne blive genereret og ligge i det aktuelle
katalog (har man nogen pakker, vil HTML-filerne ligge i de
tilsvarende underkataloger).</P>
<P CLASS="western">&Oslash;nsker man, at de genererede HTML-filer
skal l&aelig;gges andetsteds, kan det specificeres med parameteren -d
og stien, f.eks.:</P>
<PRE CLASS="western">  javadoc -d /tmp/javadoc-filer *.java</PRE><P CLASS="western">
hvorefter <SPAN LANG="da-DK">HTML'en</SPAN> l&aelig;gges i kataloget
/tmp/javadoc-filer<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>.</P>
<P CLASS="western">Parameteren '*.java' tager alle de .java-filer,
der findes i det aktuelle katalog. 
</P>
<P CLASS="western">Hvis man arbejder med pakker, kan man ogs&aring;
blot n&aelig;vne pakkens navn. Har man f.eks. defineret pakken 'vp',
kan man skrive (fra kilde-rodkataloget, dvs. overkataloget til 'vp')</P>
<PRE CLASS="western">  javadoc vp</PRE><P CLASS="western">
hvorefter der bliver genereret dokumentation for alle vp-pakkens
klasser (alle .java-filer i det tilsvarende underkatalog) og
eventuelle underpakker.</P>
<P CLASS="western">De vigtigste kommandolinje-parametre til javadoc
er beskrevet i <a href='kapitel2.jsp#afsn2.3.1'>afsnit 2.3.1</a>.</P>
<H3 CLASS="western">2.2.2 <a name='afsn2.2.2'></a>Henvise til den eksisterende
javadokumentation</H3>
<P CLASS="western">Ofte (faktisk altid) vil ens metoder returnere
(eller have som parametre) nogle objekter fra standardbiblioteket. I
eksemplet med EnKommenteretKlasse tager metoden en streng, men
klassen <SPAN LANG="da-DK">java.lang.String</SPAN> har vi ikke selv
lavet, og derfor er der ikke nogen henvisning til dokumentation for
den, da javadoc som udgangspunkt genererer HTML-dokumentation, der
ikke henviser til eksterne kilder.</P>
<P CLASS="western">Det kan dog laves om ved at fort&aelig;lle
javadoc, hvor den eksterne dokumentation befinder sig, med
parameteren -link, f.eks.:</P>
<PRE CLASS="western">  javadoc -link http://java.sun.com/j2se/1.3/docs/api/ *.java </PRE><P CLASS="western">
Herefter vil der blive henvist til javas standarddokumentation p&aring;
Suns hjemmeside, hver gang javadoc m&oslash;der returtyper,
<SPAN LANG="da-DK">parametertyper</SPAN>, superklasser/implementerede
interfaces og kastede undtagelser fra standardbiblioteket.</P>
<H2 CLASS="western">2.3 <a name='afsn2.3'></a>Appendiks</SPAN></H2>
<H3 CLASS="western">2.3.1 <a name='afsn2.3.1'></a>Parametre til javadoc</H3>
<P CLASS="western">Den generelle brug af javadoc er:</P>
<PRE CLASS="western">  javadoc [tilvalg] [pakkenavne] [<SPAN LANG="da-DK">kildetekstfiler</SPAN>] [klassenavne]</PRE><P CLASS="western">
hvor de vigtigste tilvalg (flag) er beskrevet herunder:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Tilvalg
til javadoc. En fuld liste over tilvalg f&aring;s ved at skrive
'javadoc' fra kommandolinjen.</I></FONT></P>
<P CLASS="klasseoversigt---kompakt-western">-public    Medtag kun ting
(klasser, interfaces, variabler, metoder) erkl&aelig;ret public</P>
<P CLASS="klasseoversigt---kompakt-western">-protected    Medtag kun
ting erkl&aelig;ret protected eller public (standardindstilling)</P>
<P CLASS="klasseoversigt---kompakt-western">-package    Medtag alt
undtagen ting erkl&aelig;ret private</P>
<P CLASS="klasseoversigt---kompakt-western">-private    Medtag alt</P>
<P CLASS="klasseoversigt---kompakt-western">-<SPAN LANG="da-DK">sourcepath</SPAN>
&lt;sti-liste&gt;  Angiv, hvor .java-filer med kildeteksten kan findes</P>
<P CLASS="klasseoversigt---kompakt-western">-<SPAN LANG="da-DK">classpath</SPAN>
&lt;sti-liste&gt;    Angiv, hvor bin&aelig;re <SPAN LANG="da-DK">.class</SPAN>-filer
i &oslash;vrigt kan findes</P>
<P CLASS="klasseoversigt---kompakt-western">-d
&lt;directory&gt;    Destinationskatalog for de genererede HTML-filer</P>
<P CLASS="klasseoversigt---kompakt-western">-use    Medtag oversigter
over, hvor klasser og pakker bruges henne</P>
<P CLASS="klasseoversigt---kompakt-western">-version    Medtag
@version-afsnit</P>
<P CLASS="klasseoversigt---kompakt-western">-author    Medtag
<SPAN LANG="da-DK">@author</SPAN>-afsnit</P>
<P CLASS="klasseoversigt---kompakt-western">-link &lt;url&gt;    Opret
eksterne henvisninger til eksisterende javadoc p&aring; &lt;url&gt;</P>
<P CLASS="klasseoversigt---kompakt-western">-<SPAN LANG="da-DK">nodeprecated</SPAN>    <SPAN LANG="da-DK">Ignor&eacute;r</SPAN>
<SPAN LANG="da-DK">@deprecated</SPAN> (frar&aring;dede
metoder/klasser)</P>
<P CLASS="klasseoversigt---kompakt-western">-<SPAN LANG="da-DK">nosince</SPAN>    Ignorer
@since (hvorn&aring;r noget blev indf&oslash;rt i programmet)</P>
<P CLASS="klasseoversigt---kompakt-western">-<SPAN LANG="da-DK">nodeprecatedlist</SPAN>    Opret
ikke liste over frar&aring;dede ting</P>
<P CLASS="klasseoversigt---kompakt-western">-<SPAN LANG="da-DK">notree</SPAN>    Opret
ikke et tr&aelig; over klassehierarkiet</P>
<P CLASS="klasseoversigt---kompakt-western">-<SPAN LANG="da-DK">noindex</SPAN>    Opret
ikke en indholdsfortegnelse over klasserne</P>
<P CLASS="klasseoversigt---kompakt-western">-<SPAN LANG="da-DK">nohelp</SPAN>    Opret
ikke en henvisning til hj&aelig;lp</P>
<P CLASS="klasseoversigt---kompakt-western">-<SPAN LANG="da-DK">nonavbar</SPAN>    Opret
ikke en navigations-bj&aelig;lke</P>

<H3 CLASS="western" STYLE="">2.3.2 <a name='afsn2.3.2'></a>Koder
tilg&aelig;ngelige i javadoc</H3>
<P CLASS="western">I eksemplet er der knyttet Javadoc-kommentarer til
metoder og<SPAN LANG="da-DK"> klassevariabler </SPAN>samt klassen
selv. I de fleste af kommentarerne anvendes der Javadoc-koder.</P>
<UL>
  <LI><P CLASS="western">@author angiver ophavsmanden til klassen. Det
  er muligt at angive flere @author-koder p&aring; separate linjer,
  s&aring;fremt der er flere ophavsm&aelig;nd.</P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">@version</SPAN>, der er
  obligatorisk, angiver <SPAN LANG="da-DK">versionsnummeret</SPAN> og
  er for Javadoc-kommentarernes vedkommende beregnet til klasser og
  interfaces. <SPAN LANG="da-DK">Versionsnummeret</SPAN> har ikke
  nogen speciel betydning og kan derfor v&aelig;re hvad som helst.</P>
  <LI><P CLASS="western">@since angiver, fra hvilken version
  tilf&oslash;jelsen fandt sted, og kan bruges overalt.
  Versionsnummeret har ikke nogen speciel betydning og kan derfor v&aelig;re
  hvad som helst.</P>
  <LI><P CLASS="western">@param beskriver en parameter og er beregnet
  til metoder og konstrukt&oslash;rer. F&oslash;rst angives<SPAN LANG="da-DK">
  parameterens </SPAN>navn og dern&aelig;st beskrivelsen.</P>
  <LI><P CLASS="western">@return beskriver returv&aelig;rdien af en
  metode.</P>
  <LI><P CLASS="western">@exception g&oslash;r det samme som @throws.</P>
  <LI><P CLASS="western">@throws beskriver en undtagelse og er
  beregnet til metoder og konstrukt&oslash;rer. Der kan v&aelig;re
  flere @throws-koder. Efter hver @throws skal st&aring; klassenavnet
  p&aring; undtagelsen og en beskrivelse af hvorn&aring;r denne
  undtagelse opst&aring;r.</P>
  <LI><P CLASS="western">@see henviser til en pakke, interface,
  klasse, variabel, konstrukt&oslash;r eller metode. En af de mulige
  henvisningsformer er @see <SPAN LANG="da-DK">pakkenavn.klassenavn</SPAN>#medlem,
  hvor medlem kan v&aelig;re et metodenavn med parametertyper eller et
  <SPAN LANG="da-DK">variabelnavn.</SPAN> Pakkenavn og klassenavn kan
  udelades, hvis der henvises til en metode eller variabel indenfor
  samme klasse. 
  </P>
  <LI><P CLASS="western">@deprecated kan bruges overalt og angiver, at
  en metode (eller en variabel, klasse, interface, ...) ikke l&aelig;ngere
  b&oslash;r anvendes (og muligvis vil udg&aring; i en senere
  version). Det er anbefalelsesv&aelig;rdigt at henvise til et
  alternativ ved hj&aelig;lp af @see.</P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">@serial</SPAN> kan bruges
  til at komme med bem&aelig;rkninger om <SPAN LANG="da-DK">serialiseringen</SPAN>
  af klassen.</P>
</UL>

<H3 CLASS="western">2.3.3 <a name='afsn2.3.3'></a>Pakkekommentarer</H3>
<P CLASS="western">En pakkekommentar laves ved at oprette en HTML-fil
kaldet <SPAN LANG="da-DK">package.html</SPAN>, der placeres i pakkens
katalog. Hvis pakken f.eks. hedder 'vp', s&aring; placeres filen i
underkataloget 'vp' (der hvor .java-filerne ogs&aring; ligger),
hvorefter javadoc s&oslash;rger for at medtage filen. 
</P>
<P CLASS="western">Her er et eksempel p&aring; en pakkekommentar:</P>
<PRE CLASS="kode-western">&lt;html&gt;
  &lt;head&gt;&lt;title&gt;package&lt;/title&gt;&lt;/head&gt;
  &lt;body&gt;
    Dette er et eksempel p&aring; en pakkekommentar. 
    Den skal ligge i filen package.html sammen med .java-filerne den beskriver.

    @author Jacob Nordfalk
    @since 1.0
  &lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
Javadoc bruger kun det, der st&aring;r mellem &lt;body&gt; og
&lt;/body&gt;, s&aring; titlen kan v&aelig;re hvad som helst. Det er
muligt at anvende visse Javadoc-koder i pakkekommentarer, nemlig
@author, @version, @since, @deprecated og @see.</P>
<P CLASS="western">Bem&aelig;rk, at HTML-filen med pakkekommentarer
ikke m&aring; indeholde /** ... */, og at en linje ikke m&aring;
starte med *.</P>
<H2 CLASS="western">2.4 <a name='afsn2.4'></a>Videre l&aelig;sning</SPAN></H2>
<UL>
  <LI><P CLASS="western">P&aring; UNIX/Linux-systemer giver 'man
  javadoc' en meget udf&oslash;rlig vejledning</P>
  <LI><P CLASS="western">Javadoc-v&aelig;rkt&oslash;jets hjemmeside,
  <SPAN STYLE="font-weight: medium"><A CLASS="western" HREF="http://java.sun.com/j2se/javadoc/" TARGET="_top">http://java.sun.com/j2se/javadoc/</A></SPAN></P>
  <LI><P CLASS="western">R&aring;d og vejledning til god praksis
  omkring at skrive javadoc-kommentarer:<BR>
  <A CLASS="western" HREF="http://java.sun.com/j2se/javadoc/writingdoccomments/x" TARGET="_top">http://<SPAN LANG="da-DK">java.sun.com</SPAN>/j2se/javadoc/<SPAN LANG="da-DK">writingdoccomments</SPAN>/</A></P>
</UL>

<H2 CLASS="western">2.5 <a name='afsn2.5'></a>Opgaver</SPAN></H2>
<OL>
  <LI><P CLASS="western">Kig i kildeteksten til Vector-klassen (den
  kan findes i <a href='kapitel1.jsp#afsn1.6.8'>afsnit 1.6.8</a> eller i din java-installation, ofte i
  filen src.zip), og <SPAN LANG="da-DK">stud&eacute;r</SPAN> metoderne
  insertElementAt() og toArray(). <BR>Sammenlign med
  javadokumentationen (hj&aelig;lpen) til Vector, og find ud af, hvad
  koderne @param, @exception, @see, @return og @since g&oslash;r.</P>
  <LI><P CLASS="western">Hent klassen <SPAN LANG="da-DK">Sender<SPAN STYLE="font-weight: medium">ActionEvent</SPAN></SPAN><SPAN STYLE="font-weight: medium">
  fra <a href='kapitel4.jsp#afsn4.3.5'>afsnit 4.3.5</a> ned til dig selv, og <SPAN LANG="da-DK">gener&eacute;r</SPAN>
  dens HTML-dokumentation.</SPAN></P>
  <LI><P CLASS="western" STYLE="font-weight: medium">Medtag
  henvisninger til standarddokumentationen med parameteren -link
  <BR>(beskrevet i <a href='kapitel2.jsp#afsn2.2.2'>afsnit 2.2.2</a>, Henvise til den eksisterende javadokumentation).</P>
</OL>
<H2 CLASS="western" STYLE="">2.6 <a name='afsn2.6'></a>L&oslash;sninger</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_VP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/VP/kapitel2.jsp#afsn2.6">
  <input type='checkbox' name='vis' value='2.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>Under
  UNIX/Linux. Under DOS/Windows skriver man f.eks.
  c:\tmp\javadoc-filer</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel1.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel3.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_VP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (71% af vrket).
</font>
<br>
nsker du at se de sidste 29% af dette vrk (362838 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
